<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Parent controller for areas of the site limited to logged-in users.
*
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Restricted_controller extends CI_Controller {
	protected $permissions;
	public $user; //a User object for the logged-in user
	
	function __construct() {	
		parent::__construct();
		
		//BEFORE ANYTHING ELSE, CHECK TO MAKE SURE THAT WE HAVE A LOGGED IN USER
	
		//log out if we don't have a username in the session
		if(empty($this->session->userdata('username'))){
			return User::log_out('auth'); //go to the main login page because we don't know whether this person's session timed out or if they never logged in
		}
		
		//if this isn't the first page load after logging in ....
		if(!empty($this->session->userdata('app_last_activity'))){
			
			//log the user out if their session has expired
			$lapsed_time = abs($this->session->userdata('app_last_activity') - time());
			if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)){
				if(is_on_local())
					log_message('debug', 'Logging out user '.$this->session->userdata('username').' because it has been '.timespan($this->session->userdata('app_last_activity')).' ('.$lapsed_time.' seconds) since last activity');
				return User::log_out(); 
			}
				
			//make a note of their current last activity before we update it - we'll reset it for functions that we don't want to consider 'activity'
			$this->session->set_userdata('prev_last_activity', $this->session->userdata('app_last_activity'));
		}

		$this->session->set_userdata('app_last_activity', time()); 
		
		//make sure that the user hasn't been deactivated in the database
		$this->user = User::find_one(array('user_deleted_flag' => 0, 'user_name' => $this->session->userdata('username')));
		if(!User::is_an_entity($this->user)) return User::log_out();
		
		//HANDLE USER SETTINGS
		
		//if the user has a timezone, set it.  
		$locale = unserialize($this->user->user_locale);
		if($locale) $locale = $this->locale->get_timezone_from_id($locale['timezone']);
		if($locale) date_default_timezone_set($locale);
		
		//connect to LDAP and determine the user's group memberships
		$this->load->library('ldap', array( 'user' => $this->user->username, 'pwd' => $this->encrypt->decode($this->session->userdata('ep'))));
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$this->user->username.','.LDAP_ACCOUNTS_DN);
		$this->session->set_userdata('group_mailboxes',$group_mailboxes);
		
		$this->permissions = $this->role_model->user_permissions($this->user->dn);
		
		//LOAD & CONFIGURE ANY REMAINING LIBRARIES THAT CAN'T BE HANDLED BY AUTOLOAD
		$this->form_validation->set_error_delimiters('', '');
	}	
	
	/** True if the logged-in user has the given permission.  For an automatic redirect, see {@link verify_permission} */
	public function has_permission($permission){
		if($this->user->is_admin) return true;
		return in_array($permission,$this->permissions);
	}
	
	/** Redirects to a 404 page if the user does not have the given permission.  For a boolean check, see {@link has_permission}. */
	public function verify_permission($permission){
		if($this->has_permission($permission)) return true;
		show_404();
		return false; //on the off chance that the redirect didn't work, return false
	}
	
	//call this method whenever a controller action should not be considered user activity (e.g. autosave)
	//todo - better name?
	protected function action_is_not_user_activity(){
		//this is pretty code-light at the moment, but keep it in this method to make it easier to add debugging code or future changes
		$this->session->set_userdata('app_last_activity', $this->session->userdata('prev_last_activity'));	
	}
	
	//deprecated - just access the class var directly
	protected function get_user_id($username) {
		return $this->user->id;
	}	
}